package gov.va.med.mhv.integration.phr.evault.dao;

import gov.va.med.mhv.integration.phr.evault.transfer.EmploymentReport;

public interface EmploymentReportDAO {

	/**
	 * This method deletes the Employment Report database records based on the row id.
	 *
	 * @param id
	 * @return
	 */
	public abstract int delete(Long id);

	public abstract Long getUserProfileId(String icn);

	/**
	 * This method deletes the Employment Report database records based on the
	 * user profile id.
	 *
	 * @param id
	 * @return
	 */
	public abstract int deleteByUserProfileId(Long id);

	/**
	 * This method determines if an update or insert gets called.
	 *
	 * @param record
	 */
	public abstract void persist(EmploymentReport record);

	/**
	 * This method simply inserts the record
	 * 	 *
	 * @param record
	 */
	public abstract void insert(EmploymentReport record);

	/**
	 * This method simply updates the existing record
	 *
	 *
	 * @param record
	 */
	public abstract void update(EmploymentReport record);

	/**
	 * This method is responsible for retrieving a specific Employment Report record
	 * based on the row id.
	 *
	 * @param id
	 * @return
	 */
	public abstract EmploymentReport findById(Long id);

	/**
	 * This method is responsible for retrieving a specific Employment Report record
	 * based on the user.
	 *
	 * @param id
	 * @return
	 */
	public abstract EmploymentReport findByUserProfileId(Long id);

}